using gov.va.med.vbecs.Common;
using System;
using System.Collections.Generic;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingSpecimenAboRhModel
    /// </summary>
    public class PendingSpecimenAbsModel : PendingTestModel, IPendingSpecimenTestModel
    {
        /// <summary>
        /// PatientSpecimenGuid
        /// </summary>
        public Guid PatientSpecimenGuid { get; set; }
        /// <summary>
        /// SpecimenUid
        /// </summary>
        public string SpecimenUid { get; set; }
        /// <summary>
        /// OrderedTest
        /// </summary>
        public OrderedTest OrderedTest { get; set; }
        /// <summary>
        /// SpecimenResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// SpecimenExpirationDate
        /// </summary>
        public DateTime? SpecimenExpirationDate { get; set; }
        /// <summary>
        /// CprsOrderNumber
        /// </summary>
        public string CprsOrderNumber { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                if (AbsInterp != null)
                {
                    return AbsInterp.TestResultText;
                }

                return "";
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                return WorkloadProcessID.AutomatedAntiBodyScreen;
            }
        }
        /// <summary>
        /// SC1
        /// </summary>
        public PendingTestResultModel SC1
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.ABS_AHG_SC1,
                    TestType.AbsRepeat_AHG_SC1,
                    TestType.ABS_TAS_SC1,
                };
                return GetPendingTestResult(typeTypeList, true);
            }
        }
        /// <summary>
        /// SC2
        /// </summary>
        public PendingTestResultModel SC2
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.ABS_AHG_SC2,
                    TestType.AbsRepeat_AHG_SC2,
                    TestType.ABS_TAS_SC2,
                };
                return GetPendingTestResult(typeTypeList, true);
            }
        }
        /// <summary>
        /// SC3
        /// </summary>
        public PendingTestResultModel SC3
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.ABS_AHG_SC3,
                    TestType.AbsRepeat_AHG_SC3,
                    TestType.ABS_TAS_SC3,
                };
                return GetPendingTestResult(typeTypeList, true);
            }
        }
        /// <summary>
        /// SC4
        /// </summary>
        public PendingTestResultModel SC4
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.ABS_AHG_SC4,
                    TestType.AbsRepeat_AHG_SC4,
                    TestType.ABS_TAS_SC4,
                };
                return GetPendingTestResult(typeTypeList, true);
            }
        }
        /// <summary>
        /// SC5
        /// </summary>
        public PendingTestResultModel SC5
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.ABS_Auto_SC5,
                    TestType.AbsRepeat_Auto_SC5,
                    TestType.ABS_TAS_SC5,
                };
                return GetPendingTestResult(typeTypeList, true);
            }
        }

        /// <summary>
        /// AbsInterp
        /// </summary>
        public PendingTestResultModel AbsInterp
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.AntibodyScreen,
                    TestType.AntibodyScreenRepeat,
                    TestType.AntibodyScreenTAS,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }

        /// <summary>
        /// Validate Test
        /// </summary>
        public TestValidationModel Validate()
        {
            return BOL.TestValidation.ValidatePatientABS(
                        SC1 == null ? string.Empty : SC1.TestResultId,
                        SC2 == null ? string.Empty : SC2.TestResultId,
                        SC3 == null ? string.Empty : SC3.TestResultId,
                        SC4 == null ? string.Empty : SC4.TestResultId,
                        SC5 == null ? string.Empty : SC5.TestResultId,
                        AbsInterp == null ? string.Empty : AbsInterp.TestResultId,                        
                        OrderedTest,
                        SpecimenExpirationDate);
        }

        /// <summary>
        /// GetTasBloodTestTypeIds
        /// </summary>
        /// <returns></returns>
        public static IList<TestType> GetTasBloodTestTypeIds()
        {
            return new List<TestType>()
            {
                TestType.ABS_TAS_SC1,
                TestType.ABS_TAS_SC2,
                TestType.ABS_TAS_SC3,
                TestType.ABS_TAS_SC4,
                TestType.ABS_TAS_SC5,
                TestType.AntibodyScreenTAS
            };
        }
    }
}



